

PROCEDURE MAXFLOW(
       N,S,T,MAX:INTEGER;
   VAR CAPA,FLOW:ARRNN);

   VAR LCAPA,LFLOW,EL         :ARRNN;
       LABELS,LAYERS,PRED,SUCC:ARRN;
       DATA,LINK              :ARRMAX;
       STPATH                 :BOOLEAN;
       AV,I,J,L,DIF           :INTEGER;

   PROCEDURE ADD(VAR A:ARRN;I,X:INTEGER);
      VAR P    :INTEGER;
          FOUND:BOOLEAN;
   BEGIN
       FOUND:=FALSE;
       P:=A[I];
       WHILE (NOT FOUND) AND (P <> 0) DO
          IF DATA[P] = X THEN FOUND:=TRUE
          ELSE P:=LINK[P];
       IF NOT FOUND THEN BEGIN
          P:=AV;  AV:=LINK[AV];
          DATA[P]:=X;  LINK[P]:=A[I];
          A[I]:=P
       END  { IF NOT FOUND }
   END;  { ADD }

   PROCEDURE DELETE(VAR A:ARRN;I,X:INTEGER);
      VAR P,Q:INTEGER;
   BEGIN
      P:= A[I];
      IF DATA[P] = X THEN A[I]:=LINK[P]
      ELSE BEGIN
         WHILE DATA[P] <> X DO BEGIN
            Q:=P;  P:=LINK[P]
         END;
         LINK[Q]:=LINK[P]
      END
   END;  { DELETE }

   PROCEDURE LAYER(VAR L:INTEGER;VAR LCAPA,EL:ARRNN;
                   VAR STPATH:BOOLEAN);
      VAR I,J,P,Q,X,Y,V,W:INTEGER;
   BEGIN
      STPATH:=TRUE;
      FOR V:=1 TO N DO BEGIN
         LABELS[V]:=-1;
         SUCC[V]:=0;  PRED[V]:=0
      END;
      P:=AV;  AV:=LINK[AV];
      DATA[P]:=S;  LINK[P]:=0;
      LAYERS[1]:=P;  LABELS[S]:=1;
      FOR X:=1 TO N DO
         FOR Y:=1 TO N DO LCAPA[X,Y]:=CAPA[X,Y];
      FOR X:=1 TO N DO
         FOR Y:=1 TO N DO BEGIN
            EL[X,Y]:=0;
            IF FLOW[X,Y] > 0 THEN BEGIN
               LCAPA[X,Y]:=CAPA[X,Y]-FLOW[X,Y];
               LCAPA[Y,X]:=FLOW[X,Y]+LCAPA[Y,X]
            END
         END;  { FOR Y, X }                   { INITIALIZATION OVER }
      I:=1;                        { FORWARD TRAVERSAL AND LABELING }
      WHILE (LAYERS[I] <> 0) AND (LABELS[T] = -1) DO BEGIN
         LAYERS[I+1]:=0;  P:=LAYERS[I];
         WHILE P <> 0 DO BEGIN
            X:=DATA[P];
            FOR Y:=1 TO N DO
               IF ((LABELS[Y] = -1) OR (LABELS[Y] = I+1))
                  AND (LCAPA[X,Y] > 0) THEN BEGIN
                  ADD(LAYERS,I+1,Y);
                  LABELS[Y]:=I+1;
                  ADD(SUCC,X,Y);  ADD(PRED,Y,X);
                  EL[X,Y]:=1
               END  { IF ((LABELS[Y] = -1) ... }
               ELSE LCAPA[X,Y]:=0;
            P:=LINK[P]
         END;  { WHILE P <> 0 }
         I:=I+1
      END;  { WHILE (LAYERS[I] <> 0) ... }
      L:=I;                        { BACKWARD TRAVERSAL AND PRUNING }
      IF LABELS[T] = -1 THEN STPATH:=FALSE
      ELSE BEGIN
         J:=I;
         WHILE J <> 1 DO BEGIN
            P:=LAYERS[J];
            WHILE P <> 0 DO BEGIN
               W:=DATA[P];
               IF (SUCC[W] = 0) AND (W <> T) THEN BEGIN
                  Q:=PRED[W];
                  WHILE Q <> 0 DO BEGIN
                     X:=DATA[Q];  EL[X,W]:=0;
                     DELETE(SUCC,X,W);
                     LCAPA[X,W]:=0;  Q:=LINK[Q]
                  END;
                  DELETE(LAYERS,J,W);
                  PRED[W]:=0;  LABELS[W]:=-1
               END;  { IF (SUCC[W] = 0) ... }
               P:=LINK[P]
            END;  { WHILE P <> 0 }
            J:=J-1
         END  { WHILE J <> 1 }
      END  { ELSE: LABELS[T] <> -1 }
   END;  { LAYER }

   PROCEDURE SATURATE(VAR L:INTEGER;VAR LFLOW,EL:ARRNN);
      VAR INPOT,OUTPOT,POTEN,INFLOW,OUTFLOW:ARRN;
          V,X,Y,I,J,K,P,R,RLAYER           :INTEGER;
          FLAG                             :BOOLEAN;

      PROCEDURE REFNODE(VAR L,R,RLAYER:INTEGER);
         VAR V:INTEGER;
      BEGIN
         POTEN[S]:=OUTPOT[S];  POTEN[T]:=INPOT[T];
         IF POTEN[S] < POTEN[T] THEN  BEGIN
            R:=S;  RLAYER:=1
         END
         ELSE  BEGIN
            R:=T;  RLAYER:=L
         END;
         FOR V:=1 TO N DO
            IF (LABELS[V] <> -1) AND (V <> S) AND (V <> T) THEN
            BEGIN
               IF INPOT[V] < OUTPOT[V] THEN POTEN[V]:=INPOT[V]
               ELSE POTEN[V]:=OUTPOT[V];
               IF POTEN[V] < POTEN[R] THEN  BEGIN
                  R:=V;
                  RLAYER:=LABELS[V]
               END
            END  { IF (LABELS[V] <> -1) ..., FOR V }
      END;  { REFNODE }

      PROCEDURE PUSH(VAR I:INTEGER);
         VAR P,Q,U,V,AVACAP:INTEGER;
      BEGIN
         P:=LAYERS[I];
         WHILE P <> 0 DO BEGIN
            U:=DATA[P];
            IF OUTFLOW[U] > 0 THEN BEGIN
               Q:=SUCC[U];
               WHILE (OUTFLOW[U] > 0) AND (Q <> 0) DO BEGIN
                  V:=DATA[Q];
                  IF LABELS[V] <> -1 THEN BEGIN
                     AVACAP:=LCAPA[U,V]-LFLOW[U,V];
                     IF AVACAP > 0 THEN BEGIN
                        { SEND MIN(AVACAP,OUTFLOW[U]) THROUGH (U,W) }
                        IF AVACAP > OUTFLOW[U] THEN
                           AVACAP:=OUTFLOW[U];
                        LFLOW[U,V]:=LFLOW[U,V]+AVACAP;
                        OUTFLOW[U]:=OUTFLOW[U]-AVACAP;
                        OUTFLOW[V]:=OUTFLOW[V]+AVACAP;
                        OUTPOT[U]:=OUTPOT[U]-AVACAP;
                        INPOT[V]:=INPOT[V]-AVACAP
                     END  { IF AVACAP > 0 }
                  END;  { IF LABELS[V] <> -1 }
                  Q:=LINK[Q]
               END  { WHILE (OUTFLOW[U] > 0) ... }
            END;  { IF OUTFLOW[U] > 0 }
            P:=LINK[P]
         END  { WHILE P <> 0 }
      END;  { PUSH }

      PROCEDURE PULL(VAR J:INTEGER);
         VAR P,Q,U,V,AVACAP:INTEGER;
      BEGIN
         P:=LAYERS[J];
         WHILE P <> 0 DO BEGIN
            U:=DATA[P];
            IF INFLOW[U] > 0 THEN BEGIN
               Q:=PRED[U];
               WHILE (INFLOW[U] > 0) AND (Q <> 0) DO BEGIN
                  V:=DATA[Q];
                  IF LABELS[V] <> -1 THEN BEGIN
                     AVACAP:=LCAPA[V,U]-LFLOW[V,U];
                     IF AVACAP > 0 THEN BEGIN
                         { SEND MIN(AVACAP,INFLOW[U]) THROUGH (V,U) }
                        IF AVACAP > INFLOW[U] THEN
                           AVACAP:=INFLOW[U];
                        LFLOW[V,U]:=LFLOW[V,U]+AVACAP;
                        INFLOW[U]:=INFLOW[U]-AVACAP;
                        INFLOW[V]:=INFLOW[V]+AVACAP;
                        OUTPOT[V]:=OUTPOT[V]-AVACAP;
                        INPOT[U]:=INPOT[U]-AVACAP
                     END  { IF AVACAP > 0 }
                  END;  { IF LABELS[V] <> -1 }
                  Q:=LINK[Q]
               END  { WHILE (INFLOW[U] > 0) ... }
            END;  { IF INFLOW[U] > 0 }
            P:=LINK[P]
         END  { WHILE P <> 0 }
      END;  { PULL }
   BEGIN                                         { BODY OF SATURATE }
      FOR V:=1 TO N DO BEGIN
         INPOT[V]:=0;  OUTPOT[V]:=0
      END;
      FOR I:=1 TO N DO
         FOR J:=1 TO N DO
            IF EL[I,J] = 1 THEN BEGIN
               INPOT[J]:=INPOT[J]+LCAPA[I,J];
               OUTPOT[I]:=OUTPOT[I]+LCAPA[I,J]
            END;  { FOR J, I }
      FOR I:=1 TO N DO
         FOR J:=1 TO N DO LFLOW[I,J]:=0;
      FLAG:=TRUE;                             { INITIALIZATION OVER }
      WHILE FLAG DO BEGIN                 { WHILE GL IS UNSATURATED }
         REFNODE(L,R,RLAYER);
         IF POTEN[R] <> 0 THEN BEGIN
            INFLOW[R]:=POTEN[R];  OUTFLOW[R]:=POTEN[R];
            FOR V:=1 TO N DO
               IF (LABELS[V] <> -1) AND (V <> R) THEN BEGIN
                  INFLOW[V]:=0;  OUTFLOW[V]:=0
               END;
            FOR K:=RLAYER TO L-1 DO PUSH(K);
            FOR J:=RLAYER DOWNTO 2 DO PULL(J)
         END;  { IF POTEN[R] <> 0 }
         IF (POTEN[R] <> 0) OR ((R <> S) AND (R <> T)) THEN BEGIN
            LABELS[R]:=-1;  P:=SUCC[R];
            WHILE P <> 0 DO BEGIN
               Y:=DATA[P];
               INPOT[Y]:=INPOT[Y]-(LCAPA[R,Y]-LFLOW[R,Y]);
               EL[R,Y]:=0;
               DELETE(SUCC,R,Y);  DELETE(PRED,Y,R);
               P:=LINK[P]
            END;  { WHILE P <> 0 }
            P:=PRED[R];
            WHILE P <> 0 DO BEGIN
               X:=DATA[P];
               OUTPOT[X]:=OUTPOT[X]-(LCAPA[X,R]-LFLOW[X,R]);
               EL[X,R]:=0;
               DELETE(SUCC,X,R);  DELETE(PRED,R,X);
               P:=LINK[P]
            END  { WHILE P <> 0 }
         END  { IF (POTEN[R] <> 0) ... }
         ELSE FLAG:=FALSE
      END  { WHILE FLAG }
   END;  { SATURATE }

   PROCEDURE INITIALIZE(MAX:INTEGER);
      VAR I:INTEGER;
   BEGIN
      FOR I:=1 TO MAX DO LINK[I]:=I+1;
      AV:=1
   END;  { INITIALIZE }

BEGIN                                                   { MAIN BODY }
   FOR I:=1 TO N DO
      FOR J:=1 TO N DO FLOW[I,J]:=0;
   INITIALIZE(MAX);                           { INITIALIZATION OVER }
   LAYER(L,LCAPA,EL,STPATH);
   WHILE STPATH DO BEGIN
      SATURATE(L,LFLOW,EL);
      FOR I:=1 TO N DO
         FOR J:=1 TO N DO
            IF LFLOW[I,J] > 0 THEN BEGIN
               DIF:=LFLOW[I,J]-FLOW[J,I];
               IF DIF > 0 THEN BEGIN
                  FLOW[I,J]:=FLOW[I,J]+DIF;
                  FLOW[J,I]:=0
               END
               ELSE FLOW[J,I]:=-DIF
            END;  { IF LFLOW[I,J] > 0, FOR J, I }
      INITIALIZE(MAX);
      LAYER(L,LCAPA,EL,STPATH)
   END  { WHILE STPATH }
END;  { MAXFLOW }

